<?php
/**
 * @version    1.0
 * @package    greenmart
 * @author     Thembay Team <support@thembay.com>
 * @copyright  Copyright (C) 2017 Thembay.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: https://thembay.com
 */

add_action('wp_enqueue_scripts', 'greenmart_child_enqueue_styles', 10000);
function greenmart_child_enqueue_styles() {
	$parent_style = 'greenmart-style';
    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'greenmart-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );

    //wp_deregister_style( 'icofont' );
    //wp_enqueue_style( 'greenmart-child-icofont', get_stylesheet_directory_uri() . '/css/icofont.css' );
}

/**
 * Function for remove srcset (WP4.4)
 *
 */
function greenmart_child_tbay_disable_srcset( $sources ) {
    return false;
}
add_filter( 'wp_calculate_image_srcset', 'greenmart_child_tbay_disable_srcset' );

if ( !function_exists('greenmart_child_remove_css_js_ver') ) {
    function greenmart_child_remove_css_js_ver( $src ) {
        if( strpos( $src, '?ver=' ) )
        $src = remove_query_arg( 'ver', $src );
        return $src;
        }
    add_filter( 'style_loader_src', 'greenmart_child_remove_css_js_ver', 10, 2 );
    add_filter( 'script_loader_src', 'greenmart_child_remove_css_js_ver', 10, 2 ); 
}
//Hide Price Range for WooCommerce Variable Products
add_filter( 'woocommerce_variable_sale_price_html', 
'lw_variable_product_price', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 
'lw_variable_product_price', 10, 2 );

function lw_variable_product_price( $v_price, $v_product ) {

// Product Price
$prod_prices = array( $v_product->get_variation_price( 'min', true ), 
                            $v_product->get_variation_price( 'max', true ) );
$prod_price = $prod_prices[0]!==$prod_prices[1] ? sprintf(__('Od: %1$s', 'woocommerce'), 
                       wc_price( $prod_prices[0] ) ) : wc_price( $prod_prices[0] );

// Regular Price
$regular_prices = array( $v_product->get_variation_regular_price( 'min', true ), 
                          $v_product->get_variation_regular_price( 'max', true ) );
sort( $regular_prices );
$regular_price = $regular_prices[0]!==$regular_prices[1] ? sprintf(__('Od: %1$s','woocommerce')
                      , wc_price( $regular_prices[0] ) ) : wc_price( $regular_prices[0] );

if ( $prod_price !== $regular_price ) {
$prod_price = '<del>'.$regular_price.$v_product->get_price_suffix() . '</del> <ins>' . 
                       $prod_price . $v_product->get_price_suffix() . '</ins>';
}
return $prod_price;
}
add_filter( 'electro_live_search_template', 'ec_include_price_in_live_search', 99 );

function ec_include_price_in_live_search( $template ) {
	$template = '<a href="{{url}}" class="media live-search-media"><img src="{{image}}" class="media-left media-object flip pull-left" height="60" width="60"><div class="media-body"><p>{{{value}}}<br/>{{{price}}}</p></div></a>';
	return $template;
}